<?php # login.php
// Strona wyświetla, jak i obsługuje proces logowania się.

// Plik konfiguracyjny zawsze musi pojawić się jako pierwszy:
require('includes/config.inc.php');

// Ustaw tytuł strony i dodaj nagłówek HTML:
$page_title = 'Logowanie';
include ('includes/header.html');

// Dodaj główny tekst:
echo '<h1>Logowanie</h1><p id="message">Zarejestrowani użytkownicy muszą się zalogować, by brać udział w aukcji.</p>
';

// Sprawdź, czy wysłano formularz:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	// Potrzebne jest połączenie z bazą danych:
	require (MYSQL);
	
	// Tablica przechowująca błędy:
	$errors = array();
	
	// Sprawdź poprawność nazwy użytkownika:
	if (isset($_POST['username']) && !empty($_POST['username'])) {
		$u = mysqli_real_escape_string ($dbc, $_POST['username']);
	} else {
		$errors[] = 'Zapomniałeś wpisać nazwę użytkownika!';
	}
	
	// Sprawdź przekazanie hasła:
	if (isset($_POST['userpass']) && !empty($_POST['userpass'])) {
		$p = mysqli_real_escape_string ($dbc, $_POST['userpass']);
	} else {
		$errors[] = 'Zapomniałeś wpisać hasło!';
	}
	
	if (empty($errors)) { // Nie ma błędów!
		
		// Zapytanie do bazy danych:
		$q = "SELECT userId, username, timezone FROM users WHERE (username='$u' AND userpass=SHA1('$p'))";
		$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Błąd MySQL: " . mysqli_error($dbc));
		
		if (@mysqli_num_rows($r) == 1) { // Znaleziono pasujący wiersz.
			
			// Zapamiętaj dane w sesji:
			$_SESSION = mysqli_fetch_array ($r, MYSQLI_ASSOC); 
			
			// Czyszczenie:
			mysqli_free_result($r);
			mysqli_close($dbc);
			
			// Wyświetl status:
			echo '<p class="good">Jesteś zalogowany.</p>';
			
			// Dodaj stopkę:
			include ('includes/footer.html');
			
			// Zakończ skrypt:
			exit(); 
			
		} else { // Brak dopasowania.
			$errors[] = 'Przekazanie wartości nie odpowiadają zapamiętanym w bazie danych.';
		}

	} // Koniec warunku IF dotyczącego $errors.

	// Zamknij połączenie z bazą dannych:
	mysqli_close($dbc);
	
} // Koniec sprawdzania danych przesłanych z formularza.

// Wyświetl błędy:
if (isset($errors) && is_array($errors)) {
	echo '<h2>Błąd!</h2><p>Proszę poprawić następujące błędy:<ul>';
	foreach ($errors as $error) {
		echo "<li class=\"error\">$error</li>";
	}
	echo '</ul></p>';
	
}

// Wyświetl formularz:
?>
<form action="logowanie.php" method="post" id="loginForm">
	<label>Nazwa użytkownika</label>
	<input name="username" id="username" type="text">
	<label>Hasło</label>
	<input name="userpass" id="userpass" type="password">
	<br>
	<input class="button" type="submit" value="Zaloguj się">
</form>

<script src="js/login.js"></script>

<?php include ('includes/footer.html'); ?>