'use strict';


var NIL  = require('../common').NIL;
var Type = require('../type');


function resolveYamlMerge(object /*, explicit*/) {
  return '<<' === object ? object : NIL;
}


module.exports = new Type('tag:yaml.org,2002:merge', {
  loader: {
    kind: 'string',
    resolver: resolveYamlMerge
  }
});
