# serve-index [![Build Status](https://travis-ci.org/expressjs/serve-index.svg?branch=master)](https://travis-ci.org/expressjs/serve-index) [![NPM version](https://badge.fury.io/js/serve-index.svg)](http://badge.fury.io/js/serve-index)

  Serves pages that contain directory listings for a given path.

## API

```js
var express   = require('express')
var directory = require('serve-index')

var app = express()

app.use(directory('public/ftp', {'icons': true}))
app.listen()
```

### directory(path, options)

  Returns middlware that serves an index of the directory in the given `path`.

#### Options

  - `hidden` - display hidden (dot) files. Defaults to `false`.
  - `view` - display mode. `tiles` and `details` are available. Defaults to `tiles`.
  - `icons` - display icons. Defaults to `false`.
  - `filter` - Apply this filter function to files. Defaults to `false`.
  - `stylesheet` - Optional path to a CSS stylesheet. Defaults to a built-in stylesheet.
  - `template` - Optional path to an HTML template. Defaults to a built-in template.
    - The following tokens are replaced in templates:
    - `{directory}` with the name of the directory.
    - `{files}` with the HTML of an unordered list of file links.
    - `{linked-path}` with the HTML of a link to the directory.
    - `{style}` with the specified stylesheet and embedded images.

## License

The MIT License (MIT)

Copyright (c) 2014 Douglas Christopher Wilson

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

The [Silk](http://www.famfamfam.com/lab/icons/silk/) icons are created
by/copyright of [FAMFAMFAM](http://www.famfamfam.com/).
