var Caller = require('../scripts/Caller.js');

describe('Sprawdzanie odpowiedzi serwera', function() {
	var caller = new Caller();
	function setTestForCode(code) {
		return function(done) {
			sinon.stub(caller, 'makeCall').yields(caller.parseResponse({
				statusCode: code
			}));
			caller.makeCall('dowolnyAdres', function(h) {
				expect(h).to.be.a('string').and.equal('obsłużone');
				done();
			});
		}
	}
	
	afterEach(function() {
		caller.makeCall.restore();
	});
		
	it('Sprawdzenie obsługi kodu 200', setTestForCode(200));
	it('Sprawdzenie obsługi kodu 404', setTestForCode(404));
	it('Sprawdzenie obsługi kodu 403', setTestForCode(403));
});