var repl = require('repl');
var net = require('net');
var events = require('events');
var Emitter = new events.EventEmitter();

module.exports = function(port) {
   net.createServer(function(socket) {
      var inst = repl.start({
         prompt: '',
         input: socket,
         output: socket,
         terminal: false
      });
   
      inst.on('exit', function () {
         socket.end();
      });

      inst.context.heapUsed = function() {
         return process.memoryUsage().heapUsed;
      }

      inst.context.send = function(msgType, msg) {
         Emitter.emit(msgType, msg);
      };
   }).listen(port);

   return Emitter;
};
