var express	= require('express');
var multer	= require('multer');
var crypto	= require('crypto')
var url 	= require('url')
var jwt 	= require('jwt-simple');

var app = express();

app.set('jwtSecret', 'shhhhhhhhh');

var server = app.listen(8080, function() {
	console.log('Nasłuchuję na porcie', server.address().port)
});

app.use(express.static(__dirname));

//	Zapewnij obsługę danych w formacie multipart.
app.use(multer())

app.post('/login', auth, function(req, res) {

	var nowSeconds 	= Math.floor(Date.now()/1000);
	var plus7Days 	= nowSeconds + (60 * 60 * 24 * 7);
	
	var token = jwt.encode({
		"iss" : "http://blogengine.com", 
		"aud" : ["http://blogsearch.com", "http://blogstorage.com"],
		"sub" : "blogengine:unikatowyIdentyfikator",
		"iat" : nowSeconds,
		"exp" : plus7Days,
		"sessionData" : encrypt(JSON.stringify({
			"department" : "sprzedaż"
		}))
	}, app.get('jwtSecret'));
	
	res.send({
		token : token
	})
})

app.post('/tokendata', function(req, res) {	
	var token = req.get('Authorization').replace('Bearer ', '');
	var decoded = jwt.decode(token, app.get('jwtSecret'));
	decoded.sessionData = JSON.parse(decrypt(decoded.sessionData));
	
	var now = Math.floor(Date.now()/1000);
	if(now > decoded.exp) {
		return res.end(JSON.stringify({
			error : "Token wygasł"
		}));
	}
	
	res.send(decoded)
})

//	Nieużywane przez JWT. Służy do szyfrowania #sessionData.
function encrypt(plaintext){
	var cipher = crypto.createCipher('aes-256-cbc', app.get('jwtSecret'));  
	return cipher.update(plaintext, 'utf8', 'hex') + cipher.final('hex');
}
 
//	Nieużywane przez JWT. Służy do odszyfrowania #sessionData.
function decrypt(encrypted) {
	var decipher = crypto.createDecipher('aes-256-cbc', app.get('jwtSecret'));
	return decipher.update(encrypted, 'hex', 'utf8') + decipher.final('utf8');
}

//	Atrapa systemu wierzytelniania -- standardowo należałoby sprawdzić otrzymane informacje w bazie danych.
function auth(req, res, next) {

	//	Sprawdź, czy otrzymaliśmy nazwę użytkownika i hasło.
	if(!req.body.username || !req.body.password) {
		return res.end(JSON.stringify({
			error: 'Nieprawidłowe dane logowania'
		}), 401);
	} 
	
	next();
}