var express = require('express');
var bodyParser= require('body-parser')
var app = express();
var MongoClient = require('mongodb').MongoClient;
var db;

app.use(bodyParser.urlencoded({extended: true}));
app.set('view engine', 'ejs')

app.get('/', function (req, res) {
  db.collection('quotes').find().toArray(function (err, result) {
    if (err) return console.log(err);
    res.render('index.ejs', {quotes: result});
  });
});

app.post('/quotes', function (req, res) {
  db.collection('quotes').save(req.body, function (err, result) {
    if (err) return console.log(err);
    res.redirect('/');
  })
});

MongoClient.connect(process.env.MONGODB_URI, function (err, database) {
  if (err) return console.log(err);
  db = database;
  app.listen(process.env.PORT || 8081, function() {
    console.log('Serwer uruchomiony');
  });
});
