var mongoose = require('mongoose');
var db = mongoose.connect('mongodb://localhost/cart');
require('./models/cart_model.js');
var Address = mongoose.model('Address');
var Billing = mongoose.model('Billing');
var Product = mongoose.model('Product');
var ProductQuantity = mongoose.model('ProductQuantity');
var Order = mongoose.model('Order');
var Customer = mongoose.model('Customer');
function addProduct(customer, order, name, imagefile, 
                    price, description, instock){
  var product = new Product({name:name, imagefile:imagefile, 
                             price:price, description:description, 
                             instock:instock});
  product.save(function(err, results){
    order.items.push(new ProductQuantity({quantity: 1, 
                                          product: [product]}));
    order.save();
    customer.save();
    console.log("Zapisano produkt: " + name);
  });
}
Product.remove().exec(function(){
  Order.remove().exec(function(){
    Customer.remove().exec(function(){
      var shipping = new Address({
        name: 'Klient A',
        address: 'Gdzieś',
        city: 'Moje miasto',
        state: 'GD',
        zip: '30-200'
      });
      var billing = new Billing({
        cardtype: 'Visa',
        name: 'Klient A',
        number: '1234567890',
        expiremonth: 1,
        expireyear: 2020,
        address: shipping
      });
      var customer = new Customer({
        userid: 'customerA',
        shipping: shipping,
        billing: billing,
        cart: []
      });
      customer.save(function(err, result){
        var order = new Order({
          userid: customer.userid,
          items: [],
          shipping: customer.shipping,
          billing: customer.billing
        });
        order.save(function(err, result){
          addProduct(customer, order, 'Wydruk łuku Delicate', 
              'arch.jpg', 12.34, 
              'Widok niesamowitego łuku Delicate w stanie Utah', 
              Math.floor((Math.random()*10)+1));
          addProduct(customer, order, 'Wydruk wulkanu', 
              'volcano.jpg', 45.45, 
              'Widok jeziora tropikalnego uformowanego przez wulkan.', 
              Math.floor((Math.random()*10)+1));
          addProduct(customer, order, 'Wydruk ruin Tikal', 
              'pyramid.jpg', 38.52, 
              'Spójrz na zadziwiającą architekturę wczesnoamerykańską.', 
              Math.floor((Math.random()*10)+1));
          addProduct(customer, order, 'Wydruk jeziora lodowcowego', 
              'lake.jpg', 77.45, 
              'Krystalicznie czysta woda o żywych kolorach spływająca z lodowca.', 
              Math.floor((Math.random()*10)+1));
        });
      });      
    });
  });
});;
