var mongoose = require('mongoose');
var db = mongoose.connect('mongodb://localhost/words');
var wordSchema = require('./word_schema.js').wordSchema;
var Words = mongoose.model('Words', wordSchema);
Words.schema.pre('init', function (next) {
  console.log('Nowy wyraz zostanie zainicjowany z bazy danych');
  next();
});
Words.schema.pre('validate', function (next) {
  console.log('Dla %s zostanie dokonane sprawdzenie poprawności', this.word);
  next();
});
Words.schema.pre('save', function (next) {
  console.log('%s zostanie zapisany', this.word);
  console.log('Ustawianie wielkości na %d', this.word.length);
  this.size = this.word.length;
  next();
});
Words.schema.pre('remove', function (next) {
  console.log('%s zostanie usunięty', this.word);
  next();
});
Words.schema.post('init', function (doc) {
  console.log('%s został zainicjowany z bazy danych', doc.word);
});
Words.schema.post('validate', function (doc) {
  console.log('Dla %s dokonano sprawdzenia poprawności', doc.word);
});
Words.schema.post('save', function (doc) {
  console.log('%s został zapisany', doc.word);
});
Words.schema.post('remove', function (doc) {
  console.log('%s został usunięty', doc.word);
});
mongoose.connection.once('open', function(){
  var newWord = new Words({
    word:'newword',
    first:'t',
    last:'d',
    size:'newword'.length,
  });
  console.log("\nZapisywanie: ");
  newWord.save(function (err){ 
    console.log("\nZnajdowanie: ");
    Words.findOne({word:'newword'}, function(err, doc){
      console.log("\nUsuwanie: ");
      newWord.remove(function(err){
        mongoose.disconnect();
      });
    });
  });
});