var net = require('net');
var server = net.createServer(function(client) {
  console.log('Połączenie z klientem: ');
  console.log('   lokalny = %s:%s', client.localAddress, client.localPort);
  console.log('   zdalny = %s:%s', client.remoteAddress, client.remotePort);
  client.setTimeout(500);
  client.setEncoding('utf8');
  client.on('data', function(data) {
    console.log('Odebrano dane z klienta na porcie %d: %s', 
                client.remotePort, data.toString());
    console.log('  Liczba odebranych bajtów: ' + client.bytesRead);
    writeData(client, 'Wysyłanie: ' + data.toString());
    console.log('  Liczba wysłanych bajtów: ' + client.bytesWritten);
  });
  client.on('end', function() {
    console.log('Rozłączono klienta');
    server.getConnections(function(err, count){
      console.log('Liczba pozostałych połączeń: ' + count);
    });
  });
  client.on('error', function(err) {
    console.log('Błąd gniazda: ', JSON.stringify(err));
  });
  client.on('timeout', function() {
    console.log('Upłynął limit czasu gniazda');
  });
});
server.listen(8107, function() {
  console.log('Serwer nasłuchujący: ' + JSON.stringify(server.address()));
  server.on('close', function(){
    console.log('Serwer zakończył działanie');
  });
  server.on('error', function(err){
    console.log('Błąd serwera: ', JSON.stringify(err));
  });
});
function writeData(socket, data){
  var success = !socket.write(data);
  if (!success){
    (function(socket, data){
      socket.once('drain', function(){
        writeData(socket, data);
      });
    })(socket, data);
  }  
}