var express = require('express');
var url = require('url');
var app = express();
app.listen(80);
app.get('/', function (req, res) {
  res.send("Uzyskanie indeksu");
});
app.get('/find', function(req, res){
  var url_parts = url.parse(req.url, true);
  var query = url_parts.query; 
  var response = 'Szukanie książki - autor: ' + query.author + 
                  ' Tytuł: ' + query.title;
  console.log('\nAdres URL zapytania: ' + req.originalUrl);  
  console.log(response);
  res.send(response);
});
app.get(/^\/book\/(\w+)\:(\w+)?$/, function(req, res){
  var response = 'Uzyskiwanie książki – rozdział: ' + req.params[0] + 
              ' Strona: ' + req.params[1];
  console.log('\nAdres URL wyrażenia regularnego: ' + req.originalUrl);
  console.log(response);
  res.send(response);
});
app.get('/user/:userid', function (req, res) {
  var response = 'Uzyskanie użytkownika: ' + req.param('userid');
  console.log('\nAdres URL parametru: ' + req.originalUrl);
  console.log(response);
  res.send(response);
});
app.param('userid', function(req, res, next, value){
  console.log("\nOdebrano żądanie z identyfikatorem użytkownika: " + value);
  next();
});

//    /find?author=Brad&title=Node
//    /book/12:15
//    /user/4983