var memdb = require('..');
var assert = require('assert');

describe('memdb', function(){
  beforeEach(function(){
    memdb.clear();
  });

  describe('.save(doc)', function(){
    it('Dokument powinien zostać zapisany', function(done){
      var pet = { name: 'Tobi' };
      memdb.save(pet, function(){
        var ret = memdb.first({ name: 'Tobi' });
        assert(ret == pet);
        done();
      });
    });
  });

  describe('.first(obj)', function(){
    it('Powinien być zwrócony pierwszy dopasowany obiekt doc', function(){
      var tobi = { name: 'Tobi' };
      var loki = { name: 'Loki' };

      memdb.save(tobi);
      memdb.save(loki);

      var ret = memdb.first({ name: 'Tobi' });
      assert(ret == tobi);

      var ret = memdb.first({ name: 'Loki' });
      assert(ret == loki);
    })

    it('W przypadku braku dopasowania doc należy zwrócić wartość null', function(){
      var ret = memdb.first({ name: 'Manny' });
      assert(ret == null);
    })
  })
})
