/**
 * Zależności w postaci modułów.
 */

var express = require('express');
var routes = require('./routes');
var user = require('./routes/user');
var http = require('http');
var path = require('path');
var routes = require('./routes');
var photos = require('./routes/photos');

var app = express();

// Wszystkie środowiska.
app.set('port', process.env.PORT || 3000);
app.set('views', __dirname + '/views');
app.set('view engine', 'ejs');
app.use(express.favicon());
app.use(express.logger('dev'));
app.use(express.bodyParser());
app.use(express.methodOverride());
app.use(app.router);
app.use(express.static(path.join(__dirname, 'public')));

app.set('photos', __dirname + '/public/photos');

// Tylko środowisko programistyczne.
if ('development' == app.get('env')) {
  app.use(express.errorHandler());
}

app.get('/users', user.list);
app.get('/', photos.list);
app.get('/upload', photos.form);
app.post('/upload', photos.submit(app.get('photos')));
app.get('/photo/:id/download', photos.download(app.get('photos')));


http.createServer(app).listen(app.get('port'), function(){
  console.log('Serwer Express nasłuchuje na porcie ' + app.get('port'));
});
