var assert = require('assert');
var Todo = require('./todo');
var todo = new Todo();
var testsCompleted = 0;

function deleteTest () {
  todo.add('Usuń mnie');
  assert.equal(todo.getCount(), 1, 'Powinien istnieć jeden element');
  todo.deleteAll();
  assert.equal(todo.getCount(), 0, 'Nie powinien istnieć żaden element');
  testsCompleted++;
}

function addTest () {
  todo.deleteAll();
  todo.add('Dodany');
  assert.notEqual(todo.getCount(), 0, 'Powinien istnieć jeden element');
  testsCompleted++;
}

function doAsyncTest (cb) {
  todo.doAsync(function (value) {
    assert.ok(value,'Wywołanie zwrotne powinno otrzymać wartość true');
    testsCompleted++;
    cb();
  })
}

function throwsTest (cb) {
  assert.throws(todo.add, /requires/);
  testsCompleted++
}

deleteTest();
addTest();
throwsTest();
doAsyncTest(function () {
  console.log('Ukończono ' + testsCompleted + ' testów');
});
