﻿using System;
using System.Net;
using System.Net.Http;
using System.Net.Http.Formatting;
using System.Threading.Tasks;
using Moq;
using Newtonsoft.Json.Linq;
using Should;
using WebApiBook.IssueTrackerApi.Models;
using Xbehave;

namespace WebApiBook.IssueTrackerApp.AcceptanceTests.Features
{
    public class CreatingIssues : IssuesFeature
    {
        private readonly Uri _issues = new Uri("http://localhost/issue");

        [Scenario]
        public void CreatingANewIssue(dynamic newIssue)
        {
            "Mając nowe zgłoszenie błędu".
                f(() =>
                {
                    newIssue = new JObject();
                    newIssue.description = "Nowe zgłoszenie błędu";
                    newIssue.title = "NewIssue";
                    MockIssueStore.Setup(i => i.CreateAsync(It.IsAny<Issue>())).Returns<Issue>( issue=>
                        {
                            issue.Id = "1";
                            return Task.FromResult("");
                        });
                });
            "Kiedy żądanie POST zostanie wykonane".
                f(() =>
                {
                    Request.Method = HttpMethod.Post;
                    Request.RequestUri = _issues;
                    Request.Content = new ObjectContent<dynamic>(newIssue, new JsonMediaTypeFormatter());
                    Response = Client.SendAsync(Request).Result;
                });
            "Wtedy zgłoszenie błędu powinno być dodane".
                f(() => MockIssueStore.Verify(i => i.CreateAsync(It.IsAny<Issue>())));
            "Wtedy będzie zwrócony kod stanu '201 Created'".
                f(() => Response.StatusCode.ShouldEqual(HttpStatusCode.Created));
            "Wtedy nagłówek Location odpowiedzi powinien wskazywać położenie zasobu".
                f(() => Response.Headers.Location.AbsoluteUri.ShouldEqual("http://localhost/issue/1"));
        }
    }
}
