﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using BCFinanceCorpoAPI.Extensions.Enums;
using BCFinanceCorpoAPI.ModelsDTO;
using BCFinanceCorpoAPI.Services.Interface;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace BCFinanceCorpoAPI.Controllers
{
    public class TransactionController : Controller
    {
        private readonly ITransactionService transactionService;

        public TransactionController(ITransactionService transactionService)
        {
            this.transactionService = transactionService;
        }

        [Route("api/transaction/getTransactionById")]
        [HttpGet]
        public TransactionsWirhObjectsListDTO GetTransactionsByUsersId(int userId, TransactionType transactionType = TransactionType.Send)
        {
            return transactionService.GetTransactionsByUsersId(userId, transactionType);
        }

        [Route("api/transaction/sendTransaction")]
        [HttpPost]
        public ResponseDTO SendTransaction(int firstUserId, int secondUserId, object sendObject, int transactionId = 0, TransactionType transactionType = TransactionType.Send)
        {
            return transactionService.SendTransaction(firstUserId, secondUserId, sendObject, transactionType, transactionId);
        }
    }
}