﻿using ShiftAssistance.Models;
using ShiftAssistance.ModelsDTO;
using ShiftAssistance.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Entity;
using System.Text;
using System.Threading.Tasks;
using ShiftAssistance.StatService;

namespace ShiftAssistance.Services.Implementation
{
    public class StatisticsService : IStatisticsService
    {
        private readonly ApplicationContext context;
        private readonly IIndicatorService indicatorsService;
        private readonly IStatService statService;

        public StatisticsService(ApplicationContext context, IIndicatorService indicatorsService)
        {
            this.context = context;
            this.indicatorsService = indicatorsService;
            this.statService = new StatServiceClient();
        }
        public BestShiftsDTO GetBestShift()
        {
            var shifts = context.Shift.Where(s => s.Date.Month == (DateTime.Now.Month == 1 ? DateTime.Now.Month + 11 : DateTime.Now.Month + 1))
                                        .Include(i => i.ShiftVal)
                                        .Include(i => i.User)
                                        .Include(i => i.User1)
                                        .Include(i => i.User2)
                                        .Include(i => i.User3);


            Dictionary<int, double?> shiftsDict = new Dictionary<int, double?>();

            foreach (Shift shift in shifts)
            {
                var indicatorday = indicatorsService.GetDayValueByDayNumber(shift.Date.Day);
                var indicatorAB = statService.MultiplyIndicators(shift.AccountBalance, shift.ShiftVal.ShiftVal, indicatorday);
                shiftsDict.Add(shift.Id, indicatorAB);

            }

            shiftsDict.OrderByDescending(o => o.Value).ToList();

            BestShiftsDTO bestShiftsList = new BestShiftsDTO() {  bestUsers= new List<BestShiftDTO>() };

            foreach (var item in shiftsDict)
            {
                var bestShift = new BestShiftDTO()
                {
                    id = item.Key,
                    result = (int)item.Value
                };

                bestShiftsList.bestUsers.Add(bestShift);
            }
            return bestShiftsList;
        }

        public BestUsersDTO GetBestUser()
        {
            var shifts = context.Shift.Where(s => s.Date.Month == (DateTime.Now.Month == 1 ? DateTime.Now.Month + 11 : DateTime.Now.Month + 1))
                                        .Include(i => i.ShiftVal)
                                        .Include(i => i.User)
                                        .Include(i => i.User1)
                                        .Include(i => i.User2)
                                        .Include(i => i.User3);

            Dictionary<string, double?> shiftsDict = new Dictionary<string, double?>();

            foreach (Shift shift in shifts)
            {
                var indicatorday = indicatorsService.GetDayValueByDayNumber(shift.Date.Day);
                var indicatorAB = statService.MultiplyIndicators(shift.AccountBalance, shift.ShiftVal.ShiftVal, indicatorday);

                if (shiftsDict.ContainsKey($"{shift.User.UserName} {shift.User.Surname}"))
                {
                    shiftsDict[$"{shift.User.UserName} {shift.User.Surname}"] = shiftsDict[$"{shift.User.UserName} {shift.User.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User.UserName} {shift.User.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.User1.UserName} {shift.User1.Surname}"))
                {
                    shiftsDict[$"{shift.User1.UserName} {shift.User1.Surname}"] = shiftsDict[$"{shift.User1.UserName} {shift.User1.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User1.UserName} {shift.User1.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.User2.UserName} {shift.User2.Surname}"))
                {
                    shiftsDict[$"{shift.User2.UserName} {shift.User2.Surname}"] = shiftsDict[$"{shift.User2.UserName} {shift.User2.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User2.UserName} {shift.User2.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.User3.UserName} {shift.User3.Surname}"))
                {
                    shiftsDict[$"{shift.User3.UserName} {shift.User3.Surname}"] = shiftsDict[$"{shift.User3.UserName} {shift.User3.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User3.UserName} {shift.User3.Surname}", indicatorAB);
                };
            }

            shiftsDict.OrderByDescending(o => o.Value).ToList();

            BestUsersDTO bestUsersList = new BestUsersDTO() { bestUsers = new List<BestUserDTO>() };

            foreach (var item in shiftsDict)
            {
                var bestUser = new BestUserDTO()
                {
                    username = item.Key,
                    result = (int)item.Value
                };

                bestUsersList.bestUsers.Add(bestUser);
            }

            return bestUsersList;
        }
    }
}
