﻿using ShiftAssistance.Models;
using ShiftAssistance.ModelsDTO;
using ShiftAssistance.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ShiftAssistance.Services.Implementation
{
    public class ShiftGenerateService : IShiftGenerateService
    {
        private readonly ApplicationContext context;
        private readonly IUserService userService;
        private readonly IShiftService shiftService;
        public ShiftGenerateService(ApplicationContext context,
                                    IUserService userService,
                                    IShiftService shiftService)
        {
            this.context = context;
            this.userService = userService;
            this.shiftService = shiftService;
        }

        Random generator;
        IList<User> users;

        public ResponseDTO GenerateShift(int cityId)
        {
            generator = new Random();
            users = this.userService.GetUersByCity(cityId);
            IList<User> usersToModify = users.ToList();

            int daysInMonth = DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.Month == 12 ? -11 : +1);
            var counterDay = 1;
            var data = new DateTime(DateTime.Now.Month == 12 ? DateTime.Now.Year + 1 : DateTime.Now.Year, DateTime.Now.Month == 12 ? DateTime.Now.Month - 11 : DateTime.Now.Month + 1, 1);

            while (counterDay <= daysInMonth)
            {
                Shift shift = new Shift()
                {
                    ShiftValId = 1,
                    Date = data,
                    CityId = cityId,
                    UserId = GetRadomUser(usersToModify).Id,
                    User1Id = GetRadomUser(usersToModify).Id,
                    User2Id = GetRadomUser(usersToModify).Id,
                    User3Id = GetRadomUser(usersToModify).Id
                };

                Shift shift2 = new Shift()
                {
                    ShiftValId = 2,
                    Date = data,
                    CityId = cityId,
                    UserId = GetRadomUser(usersToModify).Id,
                    User1Id = GetRadomUser(usersToModify).Id,
                    User2Id = GetRadomUser(usersToModify).Id,
                    User3Id = GetRadomUser(usersToModify).Id
                };

                shiftService.Add(shift);
                shiftService.Add(shift2);
                counterDay++;
                data = data.AddDays(1);
            }
            return new ResponseDTO() { Code = "200", Message = "Genreta report", Status = "Success" };
        }

        private User GetRadomUser(IList<User> usersToModify)
        {
            if (usersToModify.Count() > 0)
            {
                int i = generator.Next(0, usersToModify.Count());
                var user = usersToModify.ElementAt(i);
                usersToModify.RemoveAt(i);
                return user;
            }
            else
            {
                usersToModify = users.ToList();
                int i = generator.Next(0, usersToModify.Count());
                var user = usersToModify.ElementAt(i);
                usersToModify.RemoveAt(i);
                return user;
            }
        }
    }
}
