﻿using System;
using System.Collections.Generic;
using System.Data.Entity.ModelConfiguration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ShiftAssistance.Models.Configurations
{
    class CityConfiguration : EntityTypeConfiguration<City>
    {
        public CityConfiguration()
        {
            this.HasKey(e => e.Id);
            this.Property(e => e.CityName).IsRequired();
            this.HasMany<Shift>(a => a.Shifts)
                  .WithRequired(b => b.City)
                  .HasForeignKey(b => b.CityId)
                  .WillCascadeOnDelete(false);
            this.HasMany<User>(a => a.Users)
                  .WithRequired(b => b.City)
                  .HasForeignKey(b => b.CityId)
                  .WillCascadeOnDelete(false);
        }
    }
}
