﻿using RVAPI.ModelsDTO;
using RVAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace RVAPI.Services.Implementation
{
    public class GenerateShiftService : IGenerateShiftService
    {
        private readonly IUserService userService;
        private readonly IShiftService shiftService;

        public GenerateShiftService(IUserService userService,
                                    IShiftService shiftService)
        {
            this.userService = userService;
            this.shiftService = shiftService;
        }

        Random generator;
        IList<Users> users;

        public ResponseDTO GenerateShift(int cityId)
        {
            generator = new Random();
            users = this.userService.GetUersByCity(cityId);
            IList<Users> usersToModify = users.ToList();

            int daysInMonth = DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.Month == 12 ? -11 : +1);
            var counterDay = 1;
            var data = new DateTime(DateTime.Now.Month == 12 ? DateTime.Now.Year + 1 : DateTime.Now.Year, DateTime.Now.Month == 12 ? DateTime.Now.Month - 11 : DateTime.Now.Month + 1, 1);

            while (counterDay <= daysInMonth)
            {
                Shift shift = new Shift()
                {
                    ShiftNumber = 1,
                    Date = data,
                    CityId = cityId,
                    UserId = GetRadomUser(usersToModify).Id,
                    User2Id = GetRadomUser(usersToModify).Id,
                    User3Id = GetRadomUser(usersToModify).Id,
                    User4Id = GetRadomUser(usersToModify).Id
                };

                Shift shift2 = new Shift()
                {
                    ShiftNumber = 2,
                    Date = data,
                    CityId = cityId,
                    UserId = GetRadomUser(usersToModify).Id,
                    User2Id = GetRadomUser(usersToModify).Id,
                    User3Id = GetRadomUser(usersToModify).Id,
                    User4Id = GetRadomUser(usersToModify).Id
                };

                shiftService.Add(shift);
                shiftService.Add(shift2);
                counterDay++;
                data = data.AddDays(1);
            }
            return new ResponseDTO() { Code = "200", Message = "Genreta report", Status = "Success" };
        }

        private Users GetRadomUser(IList<Users> usersToModify)
        {
            if (usersToModify.Count() > 0)
            {
                int i = generator.Next(0, usersToModify.Count());
                var user = usersToModify.ElementAt(i);
                usersToModify.RemoveAt(i);
                return user;
            }
            else
            {
                usersToModify = users.ToList();
                int i = generator.Next(0, usersToModify.Count());
                var user = usersToModify.ElementAt(i);
                usersToModify.RemoveAt(i);
                return user;
            }
        }
    }
}