﻿using RVAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace RVAPI.Controllers
{
    public class StatisticController : Controller
    {
        // GET: Statistic
        private readonly IStatisticService statisticsService;

        public StatisticController(IStatisticService statisticsService)
        {
            this.statisticsService = statisticsService;
        }

        [HttpGet]
        public ActionResult GetBestShift()
        {
            var result = statisticsService.GetBestShift();
            return Json(result.bestShift, JsonRequestBehavior.AllowGet);
        }

        [HttpGet]
        public ActionResult GetBestUser()
        {
            var result = statisticsService.GetBestUsertByCity();
            return Json(result.bestUsers, JsonRequestBehavior.AllowGet);
        }
    }
}