using RVAPI.Services.Implementation;
using RVAPI.Services.Interface;
using System;
using System.Web.Mvc;
using Unity;
using Unity.AspNet.Mvc;

namespace RVAPI
{
    /// <summary>
    /// Specifies the Unity configuration for the main container.
    /// </summary>
    public static class UnityConfig
    {
        #region Unity Container
        private static Lazy<IUnityContainer> container =
          new Lazy<IUnityContainer>(() =>
          {
              var container = new UnityContainer();
              RegisterTypes(container);
              return container;
          });

        /// <summary>
        /// Configured Unity Container.
        /// </summary>
        public static IUnityContainer Container => container.Value;
        #endregion

        public static void RegisterTypes(IUnityContainer container)
        {
        }

        public static void RegisterComponents()
        {
            var container = new UnityContainer();
            container.RegisterType<IUserService, UserService>();
            container.RegisterType<IStatisticService, StatisticService>();
            container.RegisterType<IShiftService, ShiftService>();
            container.RegisterType<IGenerateShiftService, GenerateShiftService>();
            container.RegisterType<IIndicatorsService, IndicatorsService>();
            container.RegisterType<ShiftAssistanceEntities, ShiftAssistanceEntities>();
            DependencyResolver.SetResolver(new UnityDependencyResolver(container));
        }
    }
}