import { Component, OnInit } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { IResponse } from '../Interfaces/iresponse';
import { IUser } from '../Interfaces/iuser';
import { IUsers } from '../Interfaces/iusers';
import { UserService } from '../Services/users.service';

@Component({
  selector: 'app-admin',
  templateUrl: './admin.component.html',
  styleUrls: ['./admin.component.css']
})
export class AdminComponent implements OnInit {

  selectedComponent = 'Table';
  headElements = ['Nazwa', 'Mail', 'Num. Telefonu', 'Zapacil', 'Edytuj'];
  response: IResponse;
  user: IUser = {mail: '', name: '', password: '', telNumber: 0, isPaid: false};
  elements: IUsers = {userList: Array<IUser>()};
  userEdit: IUser;
  
  constructor(private userService: UserService, private toastr: ToastrService) { }

  ngOnInit() {
    this.getData();
  }

  async getData() {
    this.elements = await this.userService.getAllUsers();
  }

  editUser(userToEdit: IUser) {
    this.selectedComponent = 'Edit';
    this.userEdit = userToEdit;
  }

  async editUserInDB() {
    this.response = await this.userService.editUser(this.userEdit);

    if (this.response.status === 'Success') {
      this.toastr.success('Edytowano uzytkownika');
      this.selectedComponent = 'Table';
      this.elements = await this.userService.getAllUsers();
    }
  }
}
