import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { IUsers } from '../Interfaces/iusers';
import { IUser } from '../Interfaces/iuser';
import { IResponse } from '../Interfaces/iresponse';

@Injectable({
  providedIn: 'root'
})
export class UserService {

  appUrl = 'https://localhost:44305'; //Address to change

  constructor(private http: HttpClient) {}

  getAllUsers() {
    return this.http.get<IUsers>(this.appUrl + '/api/users/getAll').toPromise();
   }

   editUser(user: IUser) {
    const headers = new HttpHeaders({
      'Content-Type': 'application/json'});
    const options = { headers: headers };

    return this.http.put<IResponse>(this.appUrl + '/api/users/edit', user, options).toPromise();
   }
}