/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { getClosureSafeProperty } from '../util/property';
export var NG_COMPONENT_DEF = getClosureSafeProperty({ ngComponentDef: getClosureSafeProperty });
export var NG_DIRECTIVE_DEF = getClosureSafeProperty({ ngDirectiveDef: getClosureSafeProperty });
export var NG_PIPE_DEF = getClosureSafeProperty({ ngPipeDef: getClosureSafeProperty });
export var NG_MODULE_DEF = getClosureSafeProperty({ ngModuleDef: getClosureSafeProperty });
export var NG_LOCALE_ID_DEF = getClosureSafeProperty({ ngLocaleIdDef: getClosureSafeProperty });
export var NG_BASE_DEF = getClosureSafeProperty({ ngBaseDef: getClosureSafeProperty });
/**
 * If a directive is diPublic, bloomAdd sets a property on the type with this constant as
 * the key and the directive's unique ID as the value. This allows us to map directives to their
 * bloom filter bit for DI.
 */
// TODO(misko): This is wrong. The NG_ELEMENT_ID should never be minified.
export var NG_ELEMENT_ID = getClosureSafeProperty({ __NG_ELEMENT_ID__: getClosureSafeProperty });
//# sourceMappingURL=data:application/json;base64,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