﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using R_II_Test_API.ModelsDTO;
using R_II_Test_API.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace R_II_Test_API.Controllers
{
    public class UsersController : Controller
    {
        private readonly IUsersService usersService;
        private readonly ILogger<UsersController> logger;

        public UsersController(IUsersService usersService, ILogger<UsersController> logger)
        {
            this.usersService = usersService;
            this.logger = logger;
        }

        [HttpGet]
        [Route("/api/users/getAll")]
        public IActionResult GetAllUsers()
        {
            logger.LogInformation("Executing GetAllUsers controller");

            return Ok(usersService.GetAllUsers());
        }

        [HttpPut]
        [Route("/api/users/edit")]
        public ActionResult EditUser([FromBody]UserDTO userDTO)
        {
            logger.LogInformation("Executing EditUser controller");

            return Ok(usersService.EditUser(userDTO).Result);
        }
    }
}
