﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using R_II_Test_API.ModelsDTO;
using R_II_Test_API.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace R_II_Test_API.Controllers
{
    public class InformationController : Controller
    {
        private readonly IInformationsService informationsService;
        private readonly ILogger<InformationController> logger;

        public InformationController(IInformationsService informationsService, ILogger<InformationController> logger)
        {
            this.informationsService = informationsService;
            this.logger = logger;
        }

        [AllowAnonymous]
        [HttpPost]
        [Route("/api/information/add")]
        public IActionResult AddInformation([FromBody]InformationDTO informationDTO)
        {
            logger.LogInformation("Executing AddInformation controller");

            return Ok(informationsService.AddInformation(informationDTO));
        }

        [AllowAnonymous]
        [HttpPut]
        [Route("/api/information/edit")]
        public ActionResult EditInformation([FromBody]InformationDTO informationDTO)
        {
            logger.LogInformation("Executing EditInformation controller");

            return Ok(informationsService.EditInformation(informationDTO));
        }

        [AllowAnonymous]
        [HttpDelete]
        [Route("/api/information/delete/{informationId}")]
        public IActionResult DeleteInformation(string informationId)
        {
            logger.LogInformation("Executing DeleteInformation controller");

            return Ok(informationsService.DeleteInformation(informationId));
        }

        [AllowAnonymous]
        [HttpGet]
        [Route("/api/information/getAll/{userId}")]
        public IActionResult GetAllByUser(string userId)
        {
            logger.LogInformation("Executing GetAllByUser controller");

            return Ok(informationsService.GetAllByUser(userId));
        }
    }
}
