﻿using R_I_Test_API.Models;
using R_I_Test_API.ModelsDTO;
using R_I_Test_API.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace R_I_Test_API.Services.Implementations
{
    public class CalculatorCostService : ICalculatorCostService
    {
        private readonly CalculatorContext context;
        private readonly ICityService cityService;
        private readonly IModuleService moduleService;
        private readonly ISearchHistoryService searchHistoryService;

        public CalculatorCostService(
                CalculatorContext context,
                ICityService cityService,
                IModuleService moduleService,
                ISearchHistoryService searchHistoryService)
        {
            this.context = context;
            this.cityService = cityService;
            this.moduleService = moduleService;
            this.searchHistoryService = searchHistoryService;
        }

        OperationResultDTO ICalculatorCostService.CalculateCost(string cityName, ModuleListDTO moduleListDTO)
        {
            var city = cityService.GetCityByName(cityName);

            if (city == null)
            {
                return new OperationErrorDTO { Code = 404, Message = $"City with name: {cityName} doesn't exist" };
            }

            var modulesCost = city.TransportCost;

            foreach (String modulName in moduleListDTO.ModuleList)
            {
                var module = moduleService.GetModuleByName(modulName);

                if (module == null)
                {
                    return new OperationErrorDTO { Code = 404, Message = $"Module with name: {modulName} doesn't exist" };
                }

                modulesCost = modulesCost + module.Price + (module.AssemblyTime * city.CostOfWorkingHour);
            }

            modulesCost = modulesCost * 1.3;

            return new OperationSuccesDTO<ResultCostDTO> { Message = "Success", Result = new ResultCostDTO { Cost = modulesCost, InSearchHistory = false } };
        }
    }
}