﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace BCFinanceCorpoAPI.Models
{
    public partial class FCBlockchainContext : DbContext
    {
        public FCBlockchainContext()
        : base() { }

        public virtual DbSet<Transactions> Transactions { get; set; }
        public virtual DbSet<Users> Users { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseSqlServer(@"Server=.;Database=FCBlockchain;Trusted_Connection=True;");
            }
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Transactions>(entity =>
            {
                entity.Property(e => e.Id);

                entity.Property(e => e.Data).HasColumnType("date");

                entity.Property(e => e.ReceiveAddress).HasColumnType("varchar(50)");

                entity.Property(e => e.SendAddress).HasColumnType("varchar(50)");

                entity.HasOne(d => d.ReceiverNavigation)
                    .WithMany(p => p.TransactionsReceiverNavigation)
                    .HasForeignKey(d => d.Receiver)
                    .HasConstraintName("FK__Transacti__Recei__44FF419A");

                entity.HasOne(d => d.SenderNavigation)
                    .WithMany(p => p.TransactionsSenderNavigation)
                    .HasForeignKey(d => d.Sender)
                    .HasConstraintName("FK__Transacti__Sende__440B1D61");
            });

            modelBuilder.Entity<Users>(entity =>
            {
                entity.Property(e => e.Id);

                entity.Property(e => e.Email).HasColumnType("varchar(50)");

                entity.Property(e => e.Password).HasColumnType("varchar(50)");

                entity.Property(e => e.Surname).HasColumnType("varchar(50)");

                entity.Property(e => e.UserName).HasColumnType("varchar(50)");
            });
        }
    }
}
