﻿using ShiftAssistance.Services.Implementation;
using ShiftAssistance.Services.Interface;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using Unity;
using Unity.Injection;

namespace ShiftAssistance
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application
    {
        protected override void OnStartup(StartupEventArgs e)
        {
            base.OnStartup(e);

            IUnityContainer container = new UnityContainer();
            container.RegisterType<IIndicatorService, IndicatorService>();
            container.RegisterType<IShiftGenerateService, ShiftGenerateService>();
            container.RegisterType<IShiftService, ShiftService>();
            container.RegisterType<IStatisticsService, StatisticsService>();
            container.RegisterType<IUserService, UserService>();

            container.RegisterType<MainWindow, MainWindow>();
            container.RegisterType<MainWindow>(new InjectionConstructor(container.Resolve<IShiftGenerateService>(), 
                                                container.Resolve<IShiftService>(),
                                                container.Resolve<IStatisticsService>()));

 

            var drv = container.Resolve<MainWindow>();
            drv.Show();
        }
    }
}
