﻿using RVAPI.ModelsDTO;
using RVAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http.Cors;
using System.Web.Mvc;

namespace RVAPI.Controllers
{
    public class ShiftController : Controller
    {
        private readonly IShiftService shiftService;
        private readonly IGenerateShiftService generateShiftService;

        public ShiftController(IShiftService shiftService, IGenerateShiftService generateShiftService)
        {
            this.shiftService = shiftService;
            this.generateShiftService = generateShiftService;
        }

        [HttpGet]
        public ActionResult ShowShedule(int CityId)
        {
            return Json(shiftService.ShowShedule(CityId), JsonRequestBehavior.AllowGet);
        }

        [HttpGet]
        public ResponseDTO GenerateShift(int cityName)
        {
            var result = generateShiftService.GenerateShift(cityName);
            return result;
        }
    }
}