﻿using Microsoft.Azure.Documents;
using Microsoft.Azure.Documents.Client;
using SDBWebAPI.Models;
using SDBWebAPI.ModelsDTO;
using SDBWebAPI.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace SDBWebAPI.Services.Implemantations
{
    public class CosmoService : ICosmoService
    {
        private DocumentClient _cosmosConnection;
        private string _databaseName;
        private string _orderCollectionName;

        public CosmoService()
        {
            var url = "https://r-9.documents.azure.com:443/";
            var key = "A8rVTLZwfuD5wTMVoXNacrWl9FBaP532c5kZj6R4gdQQMwcaYHRcAMj37KK4qe6DKG8NasGuSRQMVWWkRnjMSg==";

            _databaseName = "SorageDataHistory";
            _orderCollectionName = "UploadedFile";

            _cosmosConnection = new DocumentClient(new Uri(url), key);
            _cosmosConnection.CreateDatabaseIfNotExistsAsync(new Database { Id = _databaseName });
            _cosmosConnection.CreateDocumentCollectionIfNotExistsAsync(UriFactory.CreateDatabaseUri(
            _databaseName), new DocumentCollection { Id = _orderCollectionName });
        }

        public async Task<ResponseDTO> Save(ResorceDTO resource)
        {
            try
            {
                await _cosmosConnection.CreateDocumentAsync(UriFactory.CreateDocumentCollectionUri( _databaseName, _orderCollectionName), resource);

                return new ResponseDTO() { Code = "200", Status = "Success", Message = $"Uploaded data to CosmoDb." };
            }
            catch (Exception exception)
            {
                return new ResponseDTO() { Code = "400", Status = "Failed", Message = $"Upload data to cosmoDb failed. Error message: {exception.Message}" };
            }
        }
    }
}
