﻿using BCFinanceCorpoAPI.Models;
using BCFinanceCorpoAPI.ModelsDTO;
using BCFinanceCorpoAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace BCFinanceCorpoAPI.Services.Implementation
{
    public class UserService : IUserService
    {
        private readonly FCBlockchainContext context;

        public UserService(FCBlockchainContext context)
        {
            this.context = context;
        }

        public UsersDTO GetAll()
        {
            var result = new UsersDTO() { UsersList = new List<Users>() };

            result.UsersList = context.Users.ToList();

            return result;
        }

        public ResponseDTO Login(string login, string password)
        {
            var result = context.Users.Where(u => u.Email == login && u.Password == password);

            if (result.Any())
            {
                return new ResponseDTO() { Code = "200", Status = "Success", Message = "Loged user" };
            }

            return new ResponseDTO() { Code = "404", Status = "Failed", Message = "Login failed" };
        }

        public ResponseDTO Register(Users user)
        {
            var result = context.Users.Where(u => u.Email == user.Email && u.Password == user.Password);

            if (result.Any())
            {
                return new ResponseDTO() { Code = "404", Status = "Failed", Message = "User existed in db. Please login." };
            }

            try
            {
                context.Users.Add(user);
                context.SaveChanges();

            }
            catch (Exception exception)
            {
                return new ResponseDTO() { Code = "404", Status = "Failed", Message = $"Failed during added user, error information: {exception.Message}" };
            }

            return new ResponseDTO() { Code = "200", Status = "Success", Message = "Registered user" };
        }
    }
}
