﻿using RVII.Model;
using RVII.ModelsDTO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace RVII
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "Service1" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select Service1.svc or Service1.svc.cs at the Solution Explorer and start debugging.
    public class Service1 : IService1
    {
        public BestShiftsDTO GetBestShift(IEnumerable<Shift> shifts, double indicatorday)
        {
            Dictionary<int, double?> shiftsDict = new Dictionary<int, double?>();

            foreach (Shift shift in shifts)
            {
                var indicatorAB = shift.AccountBalance * shift.ShiftVal.ShiftVal * indicatorday;
                shiftsDict.Add(shift.Id, indicatorAB);

            }

            shiftsDict.OrderByDescending(o => o.Value).ToList();

            BestShiftsDTO bestShiftsList = new BestShiftsDTO() { bestUsers = new List<BestShiftDTO>() };

            foreach (var item in shiftsDict)
            {
                var bestShift = new BestShiftDTO()
                {
                    id = item.Key,
                    result = (int)item.Value
                };

                bestShiftsList.bestUsers.Add(bestShift);
            }
            return bestShiftsList;
        }

        public BestUsersDTO GetBestUser(IEnumerable<Shift> shifts, double indicatorday)
        {
            Dictionary<string, double?> shiftsDict = new Dictionary<string, double?>();

            foreach (Shift shift in shifts)
            {
                var indicatorAB = shift.AccountBalance * shift.ShiftVal.ShiftVal * indicatorday;

                if (shiftsDict.ContainsKey($"{shift.User.UserName} {shift.User.Surname}"))
                {
                    shiftsDict[$"{shift.User.UserName} {shift.User.Surname}"] = shiftsDict[$"{shift.User.UserName} {shift.User.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User.UserName} {shift.User.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.User1.UserName} {shift.User1.Surname}"))
                {
                    shiftsDict[$"{shift.User1.UserName} {shift.User1.Surname}"] = shiftsDict[$"{shift.User1.UserName} {shift.User1.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User1.UserName} {shift.User1.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.User2.UserName} {shift.User2.Surname}"))
                {
                    shiftsDict[$"{shift.User2.UserName} {shift.User2.Surname}"] = shiftsDict[$"{shift.User2.UserName} {shift.User2.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User2.UserName} {shift.User2.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.User3.UserName} {shift.User3.Surname}"))
                {
                    shiftsDict[$"{shift.User3.UserName} {shift.User3.Surname}"] = shiftsDict[$"{shift.User3.UserName} {shift.User3.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.User3.UserName} {shift.User3.Surname}", indicatorAB);
                };
            }

            shiftsDict.OrderByDescending(o => o.Value).ToList();

            BestUsersDTO bestUsersList = new BestUsersDTO() { bestUsers = new List<BestUserDTO>() };

            foreach (var item in shiftsDict)
            {
                var bestUser = new BestUserDTO()
                {
                    username = item.Key,
                    result = (int)item.Value
                };

                bestUsersList.bestUsers.Add(bestUser);
            }

            return bestUsersList;
        }
    }
}
