﻿using RVIWPF.Models;
using RVIWPF.ModelsDTO;
using RVIWPF.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RVIWPF.Services.Implemantations
{
    public class ShiftService : IShiftService
    {
        private readonly ApplicationContext context;

        public ShiftService(ApplicationContext context)
        {
            this.context = context;
        }

        public ResponseDTO Add(Shift shift)
        {
            try
            {
                context.Shift.Add(shift);
                context.SaveChanges();
            }
            catch (Exception e)
            {
                return new ResponseDTO() { Code = "400", Message = e.Message, Status = "Failed" };
            }
            return new ResponseDTO() { Code = "200", Message = "Added shift to DB", Status = "Success" };
        }

        public IEnumerable<Shift> GatShift(int cityId)
        {
            return context.Shift.Where(s => s.CityId == cityId && s.Date.Month == (DateTime.Now.Month == 12 ? DateTime.Now.Month - 11 : DateTime.Now.Month + 1)).ToList();
        }
    }
}
