﻿using System;
using System.Collections.Generic;
using System.Data.Entity.ModelConfiguration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RVIWPF.Models.Configurations
{
    public class UserConfiguration : EntityTypeConfiguration<User>
    {
        public UserConfiguration()
        {
            this.HasKey(e => e.Id);
            this.Property(e => e.UserName).IsRequired();
            this.Property(e => e.Surname).IsRequired();
            this.Property(e => e.PhoneNumber).IsRequired();
            this.Property(e => e.Email).IsRequired();
            this.HasMany<Shift>(a => a.Shifts)
                  .WithRequired(b => b.User)
                  .HasForeignKey(b => b.UserId)
                  .WillCascadeOnDelete(false);
            this.HasMany<Shift>(a => a.Shifts1)
                  .WithRequired(b => b.User1)
                  .HasForeignKey(b => b.User1Id)
                  .WillCascadeOnDelete(false);
            this.HasMany<Shift>(a => a.Shifts2)
                  .WithRequired(b => b.User2)
                  .HasForeignKey(b => b.User2Id)
                  .WillCascadeOnDelete(false);
            this.HasMany<Shift>(a => a.Shifts3)
                  .WithRequired(b => b.User3)
                  .HasForeignKey(b => b.User3Id)
                  .WillCascadeOnDelete(false);
        }
    }
}
