﻿using System;
using System.Collections.Generic;
using System.Data.Entity.ModelConfiguration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RVIWPF.Models.Configurations
{
    class ShiftValueConfiguration : EntityTypeConfiguration<ShiftValue>
    {
        public ShiftValueConfiguration()
        {
            this.HasKey(e => e.Id);
            this.Property(e => e.ShiftNumber).IsRequired();
            this.Property(e => e.ShiftVal).IsRequired();
            this.HasMany<Shift>(a => a.Shifts)
                  .WithRequired(b => b.ShiftVal)
                  .HasForeignKey(b => b.ShiftValId)
                  .WillCascadeOnDelete(false);
        }
    }
}
