﻿using RVIWPF.Models.Configurations;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Data.Entity.ModelConfiguration.Conventions;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RVIWPF.Models
{
    public class ApplicationContext : DbContext
    {
        public ApplicationContext()
            : base("DefaultConnection")
        {
        }

        public DbSet<User> User { get; set; }
        public DbSet<City> City { get; set; }
        public DbSet<DayValue> DayValue { get; set; }
        public DbSet<Shift> Shift { get; set; }
        public DbSet<ShiftValue> ShiftValue { get; set; }


        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Conventions.Remove<OneToManyCascadeDeleteConvention>();
            modelBuilder.Configurations.Add(new UserConfiguration());
            modelBuilder.Configurations.Add(new CityConfiguration());
            modelBuilder.Configurations.Add(new DayValueConfiguration());
            modelBuilder.Configurations.Add(new ShiftConfiguration());
            modelBuilder.Configurations.Add(new ShiftValueConfiguration());
            base.OnModelCreating(modelBuilder);
        }
    }
}
