import { Component, OnInit } from '@angular/core';
import { StatisticService } from '../statistic.service';
import { IBestShift } from '../ibest-shift';
import { IBestShifts } from '../ibest-shifts';
import * as CanvasJS from './../canvasjs.min.js';

@Component({
  selector: 'app-best-shift',
  templateUrl: './best-shift.component.html',
  styleUrls: ['./best-shift.component.css']
})
export class BestShiftComponent implements OnInit {

  constructor(private statisticService: StatisticService) { }

  result: IBestShifts = {  bestUsers : Array<IBestShift>()};
  
  ngOnInit() {
    this.initCharts();
  }

  compareDataPointYDescend(dataPoint1, dataPoint2) {
    return dataPoint2.y - dataPoint1.y;
}

 async initCharts () {
  this.result.bestUsers =  await this.statisticService.getBestShift();  
  const dps = [];

  for (const i of this.result.bestUsers) {
    dps.push({
      label: i.id,
      y: i.result
  });
}

const dps2 = dps.sort();

const chart = new CanvasJS.Chart('chartContainer', {
    animationEnabled: true,
    theme: 'light2', 
    title: {
      text: 'Najlepsza zmiana'
    },
    axisY: {
      title: 'Wspołczynnik sprzedarzy'
    },
    axisX: {
      interval: 1
    },
    data: [{
      type: 'column',
      showInLegend: true,
      legendMarkerColor: 'grey',
      dataPoints: dps2
    }]
  });

  chart.options.data[0].dataPoints.sort(this.compareDataPointYDescend);
  chart.render();
  }

}
