/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/metadata/schema", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    // Metadata Schema
    // If you make a backwards incompatible change to the schema, increment the METADTA_VERSION number.
    // If you make a backwards compatible change to the metadata (such as adding an option field) then
    // leave METADATA_VERSION the same. If possible, supply as many versions of the metadata that can
    // represent the semantics of the file in an array. For example, when generating a version 2 file,
    // if version 1 can accurately represent the metadata, generate both version 1 and version 2 in
    // an array.
    exports.METADATA_VERSION = 4;
    function isModuleMetadata(value) {
        return value && value.__symbolic === 'module';
    }
    exports.isModuleMetadata = isModuleMetadata;
    function isClassMetadata(value) {
        return value && value.__symbolic === 'class';
    }
    exports.isClassMetadata = isClassMetadata;
    function isInterfaceMetadata(value) {
        return value && value.__symbolic === 'interface';
    }
    exports.isInterfaceMetadata = isInterfaceMetadata;
    function isMemberMetadata(value) {
        if (value) {
            switch (value.__symbolic) {
                case 'constructor':
                case 'method':
                case 'property':
                    return true;
            }
        }
        return false;
    }
    exports.isMemberMetadata = isMemberMetadata;
    function isMethodMetadata(value) {
        return value && (value.__symbolic === 'constructor' || value.__symbolic === 'method');
    }
    exports.isMethodMetadata = isMethodMetadata;
    function isConstructorMetadata(value) {
        return value && value.__symbolic === 'constructor';
    }
    exports.isConstructorMetadata = isConstructorMetadata;
    function isFunctionMetadata(value) {
        return value && value.__symbolic === 'function';
    }
    exports.isFunctionMetadata = isFunctionMetadata;
    function isMetadataSymbolicExpression(value) {
        if (value) {
            switch (value.__symbolic) {
                case 'binary':
                case 'call':
                case 'index':
                case 'new':
                case 'pre':
                case 'reference':
                case 'select':
                case 'spread':
                case 'if':
                    return true;
            }
        }
        return false;
    }
    exports.isMetadataSymbolicExpression = isMetadataSymbolicExpression;
    function isMetadataSymbolicBinaryExpression(value) {
        return value && value.__symbolic === 'binary';
    }
    exports.isMetadataSymbolicBinaryExpression = isMetadataSymbolicBinaryExpression;
    function isMetadataSymbolicIndexExpression(value) {
        return value && value.__symbolic === 'index';
    }
    exports.isMetadataSymbolicIndexExpression = isMetadataSymbolicIndexExpression;
    function isMetadataSymbolicCallExpression(value) {
        return value && (value.__symbolic === 'call' || value.__symbolic === 'new');
    }
    exports.isMetadataSymbolicCallExpression = isMetadataSymbolicCallExpression;
    function isMetadataSymbolicPrefixExpression(value) {
        return value && value.__symbolic === 'pre';
    }
    exports.isMetadataSymbolicPrefixExpression = isMetadataSymbolicPrefixExpression;
    function isMetadataSymbolicIfExpression(value) {
        return value && value.__symbolic === 'if';
    }
    exports.isMetadataSymbolicIfExpression = isMetadataSymbolicIfExpression;
    function isMetadataGlobalReferenceExpression(value) {
        return value && value.name && !value.module && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataGlobalReferenceExpression = isMetadataGlobalReferenceExpression;
    function isMetadataModuleReferenceExpression(value) {
        return value && value.module && !value.name && !value.default &&
            isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataModuleReferenceExpression = isMetadataModuleReferenceExpression;
    function isMetadataImportedSymbolReferenceExpression(value) {
        return value && value.module && !!value.name && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataImportedSymbolReferenceExpression = isMetadataImportedSymbolReferenceExpression;
    function isMetadataImportDefaultReference(value) {
        return value && value.module && value.default && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataImportDefaultReference = isMetadataImportDefaultReference;
    function isMetadataSymbolicReferenceExpression(value) {
        return value && value.__symbolic === 'reference';
    }
    exports.isMetadataSymbolicReferenceExpression = isMetadataSymbolicReferenceExpression;
    function isMetadataSymbolicSelectExpression(value) {
        return value && value.__symbolic === 'select';
    }
    exports.isMetadataSymbolicSelectExpression = isMetadataSymbolicSelectExpression;
    function isMetadataSymbolicSpreadExpression(value) {
        return value && value.__symbolic === 'spread';
    }
    exports.isMetadataSymbolicSpreadExpression = isMetadataSymbolicSpreadExpression;
    function isMetadataError(value) {
        return value && value.__symbolic === 'error';
    }
    exports.isMetadataError = isMetadataError;
});
//# sourceMappingURL=data:application/json;base64,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