/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { HOST, NEXT, PARENT, QUERIES, T_HOST } from './view';
/**
 * Special location which allows easy identification of type. If we have an array which was
 * retrieved from the `LView` and that array has `true` at `TYPE` location, we know it is
 * `LContainer`.
 * @type {?}
 */
export const TYPE = 1;
/**
 * Below are constants for LContainer indices to help us look up LContainer members
 * without having to remember the specific indices.
 * Uglify will inline these when minifying so there shouldn't be a cost.
 * @type {?}
 */
export const ACTIVE_INDEX = 2;
// PARENT, NEXT, QUERIES and T_HOST are indices 3, 4, 5 and 6.
// As we already have these constants in LView, we don't need to re-create them.
/** @type {?} */
export const NATIVE = 7;
/** @type {?} */
export const VIEW_REFS = 8;
/**
 * Size of LContainer's header. Represents the index after which all views in the
 * container will be inserted. We need to keep a record of current views so we know
 * which views are already in the DOM (and don't need to be re-added) and so we can
 * remove views from the DOM when they are no longer required.
 * @type {?}
 */
export const CONTAINER_HEADER_OFFSET = 9;
/**
 * The state associated with a container.
 *
 * This is an array so that its structure is closer to LView. This helps
 * when traversing the view tree (which is a mix of containers and component
 * views), so we can jump to viewOrContainer[NEXT] in the same way regardless
 * of type.
 * @record
 */
export function LContainer() { }
if (false) {
    /* Skipping unnamed member:
    readonly[HOST]: RElement|RComment|StylingContext|LView;*/
    /* Skipping unnamed member:
    [TYPE]: true;*/
    /* Skipping unnamed member:
    [ACTIVE_INDEX]: number;*/
    /* Skipping unnamed member:
    [PARENT]: LView;*/
    /* Skipping unnamed member:
    [NEXT]: LView|LContainer|null;*/
    /* Skipping unnamed member:
    [QUERIES]: LQueries|null;*/
    /* Skipping unnamed member:
    [T_HOST]: TNode;*/
    /* Skipping unnamed member:
    readonly[NATIVE]:
          RComment;*/
    /* Skipping unnamed member:
    [VIEW_REFS]: ViewRef[]|null;*/
}
// Note: This hack is necessary so we don't erroneously get a circular dependency
// failure based on types.
/** @type {?} */
export const unusedValueExportToPlacateAjd = 1;
//# sourceMappingURL=data:application/json;base64,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