# Rozdział 20. - Laboratorium - Przykładowe rozwiązanie

Uruchamianie aplikacji wykonującej długotrwałe obliczenia z wykorzystaniem odwrotengo serwera pośredniczącego, w celu poprawy efektywności działania.

## Bez korzystania z odwrotnego serwera pośredniczącego

Uruchom aplikację bez korzystania z serwera pośredniczącego:

```
docker-compose up -d
```

Sprawdź wydajność obliczając liczbę Pi z dokładnością do 50 tysięcy miejsc po przecinku:

http://localhost:8031/?dp=50000

> Na moim komputerze roboczym zajęło to około 4 sekund.

Odśwież przeglądarkę - uzyskanie tej samej odpowiedzi zajmie tyle samo czasu, gdyż wynik za każdym razem jest obliczany na nowo.

## Po zastosowaniu serwera

Dodaj domenę `pi.local` do swojego pliku *hosts* (na komputerach Mac i w systamie Linux):

```
echo \$'\n127.0.0.1 pi.local' | sudo tee -a /etc/hosts
```

**lub** w systemie Windows:

```
Add-Content -Value "127.0.0.1 pi.local" -Path /windows/system32/drivers/etc/hosts
```

Zostaw działający kontener aplikacji internetowej, po czym uruchom Nginx jako serwer pośredniczący z pamięcią podręczną; użyj [tego pliku konfiguracyjnego](./solution/sites-enabled/pi.local) - w kontenerach z systemem Linux:

```
docker-compose -f solution/docker-compose.yml -f solution/override-linux.yml up -d
```

**lub** w kontenerach z systemem Windows:

```
docker-compose -f solution/docker-compose.yml -f solution/override-windows.yml up -d
```

W przeglądarce wyświetl stronę http://pi.local?dp=50000, teraz obliczona odpowiedź zostanie zapisana w pamięci podręcznej serwera Nginx.

Odśwież przeglądarkę - przekonasz się, że tym razem wynik zostanie wyświetlony natychmiast, gdyż serwer zwróci go z pamięci podręcznej. Na poniższym rysunku widać, że obliczenie liczby Pi zajęło 3,8 sekundy, jednak odebranie odpowiedzi w rzeczywistości zajęło przeglądarce 98 ms.

![Wartość Pi z dokładnością do 50 000 miejsc po przecinku](./solution.png)
