# Rozdział 19. - Laboratorium - Przykładowe rozwiązanie

Uruchamianie aplikacji generującej liczby losowe z komunikatami przesyłanymi przy użyciu Fluentd do Elasticsearch.

## Rozwiązanie

Moje rozwiązanie składa się z trzech części:

- [solution.conf](./fluentd/conf/solution.conf) - dodaje wzbogacenia wprowadzane przez Fluentd oraz możliwość filtrowania;
- [fluentd/solution.yml](./fluentd/solution.yml) - plik przesłaniający Compose pozwalający na wykorzystanie pliku konfiguracyjnego Fluentd;
- [numbers/solution.yml](./numbers/solution.yml) - plik przesłaniający Compose zapewniający możliwość stosowania Fluentd w aplikacji.

## Testowanie

Uruchom stos Elasticsearch-Fluentd-Kibana (EFK) z bieżącego katalogu:

```
docker-compose -f fluentd/docker-compose.yml -f fluentd/solution.yml up -d
```

A taraz uruchom aplikację:

```
docker-compose -f numbers/docker-compose.yml -f numbers/solution.yml up -d
```

Wyświetl w przeglądarce stronę http://localhost:8090 i wygeneruj kilka liczb losowych.

Następnie wyświetl aplikcję Kibana dostępną pod adresem http://localhost:5601:

- ustaw wzorzec indeksowania na `fluentd`;
- a w polu time wpisz `@timestamp`.

Wpisy z dzielnnika pochodzące z kontenerów API i aplikacji internetowej będą prezentowane na karcie Discover :

![Wpisy z dzienników wyświetlane przez Kibanę](./solution.png)
