# Rozdział 18. - Laboratorium - Przykładowe rozwiązanie

Konfigurowanie aplikacji rozproszonej, by wczytywała konfiguracyjne pliki przesłaniające i zmienne środowiskowe.

## Rozwiązanie

Mój plik [docker-compose-solution.yml](./docker-compose-solution.yml) wczytuje pliki konfiguracyjne dla poszczególnych komponentów i umieszcza je na wolumnie. Pliki źródłowe mają nazwy odpowiadające oczekiwaniom poszczególnych aplikacji, a definicja woluminu umieszcza te pliki w odpowiednim katalogu.

Zmienne środowiskowe przesłaniają ustawienia z pliku konfiguracyjnego, podając nową nazwę cyklu wydania.

## Testowanie

Uruchom aplikację z poziomu tego katalogu, używając w tym celu następującego polecenia:

```
docker-compose -f docker-compose-solution.yml up -d
```

Sprawdź API konfiguracyjne:

```
curl http://localhost:8030/config
curl http://localhost:8020/config
curl http://localhost:8010/config
```

Przekonasz się, że każda aplikacja ma zmienną środowiskową `TEST` i cykl wydania o nazwie `20.01`. Kiedy wyświetlisz w przeglądarce stronę http://localhost:8010 przekonasz się, że aplikacja będzie działać:

![Skonfigurowana aplikacja korzystająca z plików przesłaniających i zmiennych środowiskowych](./solution.png)
