# Rozdział 15. - Laboratorium - Przykładowe rozwiązanie

Zacznij od przygotowania infrastruktury do budowania. Otwórz okno terminala, przejdź w nim do tego katalogu, a następnie wykonaj poniżesz polecenia:

```
cd infrastructure

# W przypadku kontenerów z systemem Linux:
docker-compose -f .\docker-compose.yml -f .\docker-compose-linux.yml up -d

# lub w przypadku kontenerów z systemem Windows
# docker-compose -f .\docker-compose.yml -f .\docker-compose-windows.yml up -d
```

## Dodaj uprawnienia Jenkinsa do dostępu do Dockera Huba

W tym celu wyświetl w przeglądarce serwis Docker Hub i przejdź w nim na stronę https://hub.docker.com/settings/security. Następnie utwórz nowy żeton dostępu (ang.: _access token_) do swojego konta. Ten żeton zapiszesz w katalogu Jenkinsa, a następnie, po zakończeniu wykonywania tego laboratorium, usuniesz (to znacznie lepsze rozwiązanie niż podawanie swojego hasła do Docker Huba).

W przeglądarce wyświetl stronę serwera Jenkins: http://localhost:8080/credentials/store/system/domain/_/

> Zaloguj się używając danych uwierzytelniających `diamol/diamol`.

Kliknij odnośnik _Add Credentials_, a następnie dodaj nowe uprawnienia uwierzytelniające dla użytkownika z hasłem (ang. username with password credential); nadaj im nazwę `docker-hub-user`, a w polach użytkownika i hasła podaj odpowiednio swój identyfikator Docker Huba i wygenerowany żetn dostępu:

![Tworzenei w Jenkinsie żetonu dostępu do Docker Huba](img/jenkins-new-cred.png)

## Skonfiguruj serwer Git i przekaż na niego kodu przykładów

Wyświetl w przeglądarce stronę serwera Gogs - http://localhost:3000 - i dokończ proces instalacji; następnie utwórz nowego użytkownika o nazwie `diamol` oraz nowe repozytorium, także o nazwie `diamol`.

Zmodyfikuj plik [Jenkinsfile](./Jenkinsfile) (lub [Jenkinsfile.windows](./Jenkinsfile.windows)) i zastąp `pwd-domain` swoją własną, **bezpieczną** domeną sesji w serwisie [Play with Docker](https://labs.play-with-docker.com).

Przekaż kody do repozytorium Git:

```
git add --all

git commit -m 'Moja domena'

git push ch15 master
```

## Uruchom potok

Wyświetl w przeglądarce stronę serwera Jenkins http://localhost:8080/job/diamol/ i klikij przycisk _Build Now_. 
Kiedy proces budoway dojdzie do etapu potwerdzenia, wróć do sesji w serwisie PWD i sprawdź wdrożenie w środowisku do testów akceptacyjnych (używając w tym celu poleceń `docker container ls` i `docker container logs`).

Wszystko w porządku? Jeśli tak to wróć do Jenkinsa i kliknij przycisk zatwierdzenia i zezwól wykonanie wdrożenia w środowisku produkcyjnym. Jeśli wszystko pójdzie dobrze, to potok powinien zostać oznaczony kolorem zielonym.

![Jenkins wykonuje proces budowania](img/jenkins-success.png)

Wróć do serwisu PWD i sprawdź wdrożenie w środowisku produkcyjnym, wszystko powinno być w porządku:

![Zastosowanie Jenkinsa do wdrażania aplikacji w serwisie PWD](img/pwd-all-good.png)
