# Rozdział 8. - Laboratorium - Przykładowe rozwiązanie

Pierwotna aplikacja została spakowana przy użyciu tego pliku [Dockerfile](./Dockerfile). Rozwiązanie, zamieszczone w pliku [Dockerfile.solution](./Dockerfile.solution), dodaje test zależności i test stanu.

## Zastosowanie

Rozwiązanie możesz zbudować używając mojego pliku Dockerfile:

```
docker image build -t diamol/ch08-lab:solution -f Dockerfile.solution .
```

Następnie możesz uruchomić kontener interaktywnie; aplikacja będzie wyświetlać swoje (fikcyjne) przydziały pamięci:

```
docker container run diamol/ch08-lab:solution
```

> Po pewnym czasie wyświetl listę kontenerów by sprawdzić stan aplikacji i zbadaj sam kontener, by sprawdzić komunikaty z testów stanu.

## Test zależności

Podczas uruchamiania kontener powinien wykonać skrypt `memory-check.js`, by przekonać się, czy dostępna pamięć jest dostatecznie duża, by można uruchomić aplikację. Jeśli okaże się, że pamięci jest dostatecznie dużo, kontener będzie mógł uruchomić aplikację, w przeciwnym razie, działanie kontenera powinno zostać zakończone.

Możesz to zrobić w sposób niezależny od platformy systemowej, używając instrukcji `CMD`:

```
CMD node memory-check.js && \
    node memory-hog.js
```

## Test stanu

W ramach testu stanu, co pięć sekund można uruchamiać ten sam skrypt `memory-check.js`, aby upewnić się, że aplikacja nie przekroczyła limitu dostępnej pamięci:

```
HEALTHCHECK --interval=5s \
 CMD node memory-check.js
```
