const restify = require("restify");
const prom = require("prom-client");
const log = require("./log");
const os = require("os");

// Deklarujemy niestandardowe metryki.
const accessCounter = new prom.Counter({
  name: "access_log_total",
  help: "Dziennik dostępu - całkowita liczba wpisów"
});

const clientIpGauge = new prom.Gauge({
  name: "access_client_ip_current",
  help: "Dziennik dostępu - bieżące unikalne adresy IP"
});

// Konfigurujemy Prometheusa przekazując etykietę z nazwą komputera.
const defaultLabels = { hostname: os.hostname() };
prom.register.setDefaultLabels(defaultLabels);
prom.collectDefaultMetrics();

function stats(req, res, next) {
  log.Logger.debug("** GET dowołanie do /stats");
  var data = {
    logs: logCount
  };
  res.send(data);
  next();
}

function respond(req, res, next) {
  log.Logger.debug("** POST /access-log called");
  log.Logger.info("Access log, client IP: %s", req.body.clientIp);
  logCount++;

  // Metryki.
  accessCounter.inc();
  ipAddresses.push(req.body.clientIp);
  let uniqueIps = Array.from(new Set(ipAddresses));
  clientIpGauge.set(uniqueIps.length);

  res.send(201, "Utworzono");
  next();
}

var logCount = 0;
var ipAddresses = new Array();
var server = restify.createServer();
server.use(restify.plugins.bodyParser());
server.get("/stats", stats);
server.post("/access-log", respond);

server.get("/metrics", function(req, res, next) {
  res.end(prom.register.metrics());
});

server.headersTimeout = 20;
server.keepAliveTimeout = 10;
server.listen(80, function() {
  log.Logger.info("%s nasłuchuje na adresie %s", server.name, server.url);
});
