# Rozdział 5. - Laboratorium - Przykładowe rozwiązanie

[Dokumentacja drugiej wersji API rejestru Dockera](https://docs.docker.com/registry/spec/api)

> Jeśli używasz programu PowerShell w systemie Windows, to polecenie `curl` jest nazwą zastępczą polecania **cmdlet** `Invoke-WebRequest`, które działa nieco inaczej niż rzeczywisty program cURL. W nowszych wersjach systemu Windows 10 program cURL jest dostępny jako `curl.exe`, dlatego zalecałbym, żeby go używać (wystarczy do poniższych poleceń dodać `.exe`)

## Przekazanie obrazu do rejestru

```
docker image push registry.local:5000/gallery/ui
```

> To polecenie przekazuje do rejestru wszystkie znaczniki obrazu.

## Sprawdzenie

```
curl http://registry.local:5000/v2/gallery/ui/tags/list
```

## Pobranie manifestu dla znacznika `latest`

```
curl --head \
  http://registry.local:5000/v2/gallery/ui/manifests/latest \
  -H 'Accept: application/vnd.docker.distribution.manifest.v2+json'
```
> Wyświetlone nagłówki zawierają `Docker-Content-Digest`, to jest właśnie manifest, którego potrzebujesz

Na przykład: 

```
Docker-Content-Digest: sha256:127d0ed6f7a8d148a39b7ea168c083694d030e2bffbda60cb53057e731114fbb
```

## Delete

```
curl -X DELETE \
  http://registry.local:5000/v2/gallery/ui/manifests/sha256:127d0ed6f7a8d148a39b7ea168c083694d030e2bffbda60cb53057e731114fbb
```

## Check 

```
curl http://registry.local:5000/v2/gallery/ui/tags/list
```