# Rozdział 21. - Laboratorium - Przykładowe rozwiązanie

Dodanie do aplikacji listy zadań programu obsługi komunikatów, która będzie modyfikować tekst wpisany przez użytkownika.

## Konfiguracja

W katalogu laboratorium jest umieszczony plik [Docker Compose](./docker-compose.yml) stanowiący moje rozwiązanie tego laboratorium. Jako początkowy posłużyła mi połączona zawartość wszystkich plików przesłaniających przedstawionych w ćwiczeniach do tego rozdziału.

Musisz ustawić zmienną środowiskową dla programu obsługi zdarzeń zapisu, która włączy publikowanie komunikatów "event-saved" (podpowiedź dotycząca tego ustawienia znajdziesz w pliku Dockerfile umieszczonym w katalogu *save-handler*)(../exercises/todo-list/src/save-handler/Dockerfile)):

```
  save-handler:
    image: diamol/ch21-save-handler
    environment:
      - Events__events.todo.itemsaved__Publish=true
    networks:
      - app-net
```

Będziesz także potrzbował nowe usługi, która dostarczy programu obsługi komunikatów modyfikujących; do jej działania będzie konieczne podanie odpowiedniego adresu URL kolejki komunikatów (w tym przypadku podpowiedź możesz znaleźć w [domyślnym pliku konfiguracyjnym aplikacji *todo-list/src/mutating-handler/appsettings.json*](../exercises/todo-list/src/mutating-handler/appsettings.json)):

```
  mutating-handler:
    image: diamol/ch21-mutating-handler
    environment:
      - MessageQueue__Url=nats://message-queue:4222
    networks:
      - app-net
```
## Próba działania aplikacji

Z poziomu tego katalogu wykonaj polecenie `docker-compose up -d`. 

Możesz sprawdzić czy działają wszystkie programu obsługi komunikatów:

```
docker container logs lab_save-handler_1
docker container logs lab_audit-handler_1
docker container logs lab_mutating-handler_1
```

Teraz wyświetl w przeglądarce stronę http://localhost:8081/new i dodaj nowy element do listy zadań. Poczekaj chwilkę na wykonanie wszystkich programów obsługi komunikatów, a następnie odśwież listę. Kiedy wszystkie aktualizacje zostaną wykonane (pamiętaj o spójości końcowej), przekonasz się, że wpisane zadanie zostało zmienione na coś bardzo ważnego:

![Modyfikowanie elementów listy zadań przy użyciu programu obsługi komunikatów](./solution.png)
