# Rozdział 16. - Laboratorium - Przykładowe rozwiązanie

W początkowym pliku [Dockerfile](./Dockerfile) występuje kilka problemów, przyczyniających się do tego, że nie może to być obraz wieloarchitekturowy:

- instrkcja `FROM` wiąże go z architekturą Linux-Intel;
- używa instrukcji `RUN` o postaci charakterystycznej dla systemu Linux;
- w poleceniach `CMD` używa poleceń charakterystycznych dla systemu Linux;
- używ ścieżek specyficznych dla sysemu Linux.

Plik [Dockerfile.solution](./Dockerfile.solution) stanowiący rozwiązanie tego laboratorium, koryguje te problemy w następujący sposób:

- używa obrazu wieloarchitekturowego jako obrazu bazowego;
- używa instrukcji `WORKDIR` do tworzenia i zmiany katalogów, zastępując nią instrukcje charakterystyczne dla konkretnych systemów operacyjnych;
- w instrukcji `CMD` używa poleceń systemowych, które działają zarówno w systamie Linux, jak i Windows.

Rozwiązanie możesz zbudować używając Dockera działającego na dowolnej platformie systemowej obsługiwanej przez przykłady prezentowane w niniejszej książce:

```
docker image build -t diamol/ch16-lab -f Dockerfile.solution .

docker container run diamol/ch16-lab
```
